<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Backend Routes
|--------------------------------------------------------------------------
|
|
*/
Route::get('ojisatriani/{folder}/{file}', 'jsController@backend');
Route::get('ojisatriani/{folder}/{id}/{file}', 'jsController@backendWithId');

Route::get('/home', 'berandaController@index')->name('beranda.home');
Route::group(['prefix' => config('master.url.admin')], function () {
	// dashboard - beranda
	Route::get('/', 'berandaController@index')->name('beranda.index');
	
	//user ubah password
	Route::get('user/ubahpassword/{id}', 'userController@ubahpassword')->name('user.ubahpassword');
	Route::group(['middleware' => ['throttle:10']], function () {
		Route::post('user/ubahpassword', 'userController@resetpassword')->name('user.store_ubahpassword');
	});
	Route::group(['middleware' => ['aksesmenu']], function (){

		//user
		Route::get('user/hapus/{id}', 'userController@hapus')->name('user.hapus');
		Route::get('user/data', 'userController@data')->name('user.data');
		Route::resource('user', 'userController');
		
		//menu
		Route::get('menu/hapus/{id}', 'menuController@hapus')->name('menu.hapus');
		Route::get('menu/data', 'menuController@data')->name('menu.data');
		Route::resource('menu', 'menuController');

		//submenu
		Route::get('submenu/hapus/{id}', 'submenuController@hapus')->name('submenu.hapus');
		Route::get('submenu/data/{id}', 'submenuController@data')->name('submenu.data');
		Route::resource('submenu', 'submenuController');

		//aksesgrup
		Route::get('aksesgrup/hapus/{id}', 'aksesgrupController@hapus')->name('aksesgrup.hapus');
		Route::get('aksesgrup/data', 'aksesgrupController@data')->name('aksesgrup.data');
		Route::get('aksesgrup/detail/data/{id}', 'aksesgrupController@data_detail')->name('aksesgrup.data_detail');
		Route::resource('aksesgrup', 'aksesgrupController');

		//aksesmenu
		Route::get('aksesmenu/data/{id}', 'aksesmenuController@data')->name('aksesmenu.data');
		Route::get('aksesmenu/create/{id}', 'aksesmenuController@create')->name('aksesmenu.create_id');
		Route::resource('aksesmenu', 'aksesmenuController');
		
		//perbaikan
		Route::get('perbaikan/data/{id}', 'perbaikanController@data')->name('perbaikan.data');
		Route::get('perbaikan/hapus/{id}', 'perbaikanController@hapus')->name('perbaikan.hapus');
		Route::get('perbaikan/create/{id}', 'perbaikanController@create')->name('perbaikan.create_id');
		Route::resource('perbaikan', 'perbaikanController');

		//berkas
		Route::get('berkas/hapus/{id}', 'berkasController@hapus')->name('berkas.hapus');
		Route::get('berkas/data', 'berkasController@data')->name('berkas.data');
		Route::get('berkas/download/{id}/{nama}', 'berkasController@download')->name('berkas.download');
		Route::resource('berkas', 'berkasController');
		
		//Organisasi
		Route::get('organisasi/hapus/{id}', 'OrganisasiController@hapus')->name('organisasi.hapus');
		Route::get('organisasi/data', 'OrganisasiController@data')->name('organisasi.data');
		Route::resource('organisasi', 'OrganisasiController');

		//UPT 
		Route::get('upt/hapus/{id}', 'uptController@hapus')->name('upt.hapus');
		Route::get('upt/data', 'uptController@data')->name('upt.data');
		Route::resource('upt', 'uptController');

		//Unor
		Route::get('unor/hapus/{id}', 'unorController@hapus')->name('unor.hapus');
		Route::get('unor/data', 'unorAsistenController@data')->name('unor.data');
		Route::resource('unor', 'unorController');

		// Unor Asisten
		Route::get('unorasisten/hapus/{id}', 'unorAsistenController@hapus')->name('unorasisten.hapus');
		Route::get('unorasisten/data', 'unorAsistenController@data')->name('unorasisten.data');	
		Route::get('unorasisten/edit', 'unorAsistenController@edit')->name('unorasisten.ubah');

		Route::resource('unorasisten', 'unorAsistenController');

		// Unor Jenis
		Route::get('unorjenis/hapus/{id}','unorJenisController@hapus')->name('unorjenis.hapus');
		Route::get('unorjenis/data','unorJenisController@data')->name('unorjenis.data');
		
		Route::resource('unorjenis', 'unorJenisController');

		//Kategori
		Route::get('kategori/data', 'kategoriController@data')->name('kategori.data');
		Route::get('kategori/hapus/{id}', 'kategoriController@hapus')->name('kategori.hapus');
		Route::get('kategori/create/{id}', 'kategoriController@create')->name('kategori.create_id');
		Route::resource('kategori', 'kategoriController');
		
		//Kategori Artikel
		Route::get('katartikel/data', 'katartikelController@data')->name('katartikel.data');
		Route::get('katartikel/hapus/{id}', 'katartikelController@hapus')->name('katartikel.hapus');
		Route::get('katartikel/create/{id}', 'katartikelController@create')->name('katartikel.create_id');
		Route::resource('katartikel', 'katartikelController');
		
		//Artikel
		Route::get('artikel/data', 'artikelController@data')->name('artikel.data');
		Route::get('artikel/hapus/{id}', 'artikelController@hapus')->name('artikel.hapus');
		//Route::get('artikel/create/{id}', 'artikelController@create')->name('artikel.create_id');
		Route::get('vieweoffice','artikelController@rmeoffice');
		Route::get('/viewlaravel','artikelController@rmlaravel');
		Route::get('/geteoffice','artikelController@artikeleoffice');
		Route::get('/getlaravel','artikelController@artikellaravel');
		Route::resource('artikel', 'artikelController');
		
		//Policy
		Route::get('policy/data', 'policyController@data')->name('policy.data');
		Route::get('policy/hapus/{id}', 'policyController@hapus')->name('policy.hapus');
		Route::get('policy/create/{id}', 'policyController@create')->name('policy.create_id');
		Route::get('policy/download/{id}/{nama}', 'policyController@download')->name('policy.download');
		Route::get('policy/policydownload/{id}/{nama}', 'policyController@policydownload')->name('policydownload.download');
		Route::resource('policy', 'policyController');
		
		//Output Government Process
		Route::get('output/data', 'outputController@data')->name('output.data');
		Route::get('output/hapus/{id}', 'outputController@hapus')->name('output.hapus');
		Route::get('output/create/{id}', 'outputController@create')->name('output.create_id');
		Route::get('output/download/{id}/{nama}', 'outputController@download')->name('output.download');
		Route::resource('output', 'outputController');
		
		//Reguler Collected Information
		Route::get('rci/data', 'regulerController@data')->name('rci.data');
		Route::get('rci/hapus/{id}', 'regulerController@hapus')->name('rci.hapus');
		Route::get('rci/create/{id}', 'regulerController@create')->name('rci.create_id');
		Route::get('rci/download/{id}/{nama}', 'regulerController@download')->name('rci.download');
		Route::resource('rci', 'regulerController');
		
		//Formal Document
		Route::get('formal/data', 'formalController@data')->name('formal.data');
		Route::get('formal/hapus/{id}', 'formalController@hapus')->name('formal.hapus');
		Route::get('formal/create/{id}', 'formalController@create')->name('formal.create_id');
		Route::get('formal/download/{id}/{nama}', 'formalController@download')->name('formal.download');
		Route::resource('formal', 'formalController');
		
		//Minutes and Report on Process
		Route::get('mr/data', 'minuteController@data')->name('mr.data');
		Route::get('mr/hapus/{id}', 'minuteController@hapus')->name('mr.hapus');
		Route::get('mr/create/{id}', 'minuteController@create')->name('mr.create_id');
		Route::get('mr/download/{id}/{nama}', 'minuteController@download')->name('mr.download');
		Route::resource('mr', 'minuteController');
		
		//Internal Communication
		Route::get('ic/data', 'internalController@data')->name('ic.data');
		Route::get('ic/hapus/{id}', 'internalController@hapus')->name('ic.hapus');
		Route::get('ic/create/{id}', 'internalController@create')->name('ic.create_id');
		Route::get('ic/download/{id}/{nama}', 'internalController@download')->name('ic.download');
		Route::resource('ic', 'internalController');

		// Cari Dokumen
		Route::resource('search', 'pencarianController');
		Route::get('sc/dataOnly', 'pencarianController@dataOnly');
		//Route::get('search/download/{id}/{nama}', 'pencarianController@formaldownload')->name('search.formaldownload');
		Route::get('search/formal/download/{id}/{nama}', 'formalController@downloadFormal')->name('search.formal.download');
		//Route::post('search/dataOnly', 'pencarianController@dataOnly');
		//Route::get('caripol', 'pencarianController@caripol');
		//Route::get('search/policy', 'pencarianController@caripol');

		// Data Only
		Route::get('dataon', 'pencarianController@dataOnly');
		
		// Artikel Backend Programming
		Route::get('backendp/data', 'backendpController@data')->name('backendp.data');
		Route::get('backendp/hapus/{id}', 'backendpController@hapus')->name('backendp.hapus');
		Route::get('backendp/create/{id}', 'backendpController@create')->name('backendp.create_id');
		Route::resource('backendp', 'backendpController');
		
		// Laravel Artikel
		Route::get('laravel/data', 'laravelController@data')->name('laravel.data');
		Route::get('laravel/hapus/{id}', 'laravelController@hapus')->name('laravel.hapus');
	//	Route::get('laravel/create/{id}', 'laravelController@create')->name('laravel.create_id');
		Route::resource('laravel', 'laravelController');
	
		// SOP Management Artikel
		Route::get('sop/data', 'sopController@data')->name('sop.data');
		Route::get('sop/hapus/{id}', 'sopController@hapus')->name('sop.hapus');
		Route::get('sop/create/{id}', 'sopController@create')->name('sop.create_id');
		Route::resource('sop', 'sopController');
	
		// Javascript Management Artikel
		Route::get('javascript/data', 'javascriptController@data')->name('javascript.data');
		Route::get('javascript/hapus/{id}', 'javascriptController@hapus')->name('javascript.hapus');
		Route::get('javascript/create/{id}', 'javascriptController@create')->name('javascript.create_id');
		Route::resource('javascript', 'javascriptController');
		
		// Framework Management Artikel
		Route::get('framework/data', 'frameworkController@data')->name('framework.data');
		Route::get('framework/hapus/{id}', 'frameworkController@hapus')->name('framework.hapus');
		Route::get('framework/create/{id}', 'frameworkController@create')->name('framework.create_id');
		Route::resource('framework', 'frameworkController');
		
		// Operating System Management Artikel
		Route::get('os/data', 'osController@data')->name('os.data');
		Route::get('os/hapus/{id}', 'osController@hapus')->name('os.hapus');
		Route::get('os/create/{id}', 'osController@create')->name('os.create_id');
		Route::resource('os', 'osController');
		
		// Content Management System Management Artikel
		Route::get('cms/data', 'cmsController@data')->name('cms.data');
		Route::get('cms/hapus/{id}', 'cmsController@hapus')->name('cms.hapus');
		Route::get('cms/create/{id}', 'cmsController@create')->name('cms.create_id');
		Route::resource('cms', 'cmsController');
		
		// Backend Programming Artikel
	// 	Route::get('beprog/data', 'backendpController@data')->name('laravel.data');
	// 	Route::get('beprog/hapus/{id}', 'backendpController@hapus')->name('laravel.hapus');
	// //	Route::get('laravel/create/{id}', 'laravelController@create')->name('laravel.create_id');
	// 	Route::resource('beprog', 'beackendpController');
		
		// Frontend Programming Artikel
		Route::get('frontendp/data', 'frontendpController@data')->name('frontendp.data');
		Route::get('frontendp/hapus/{id}', 'frontendpController@hapus')->name('frontendp.hapus');
	//	Route::get('laravel/create/{id}', 'laravelController@create')->name('laravel.create_id');
		Route::resource('frontendp', 'frontendpController');
	
		// Eoffice Artikel
		Route::get('eoffice/data', 'eofficeController@data')->name('eoffice.data');
		Route::get('eoffice/hapus/{id}', 'eofficeController@hapus')->name('eoffice.hapus');
	//	Route::get('eoffice/create/{id}', 'eofficeController@create')->name('eoffice.create_id');
		Route::resource('eoffice', 'eofficeController');

		
		
		// Forum Eoffice 
		// Route::get('aksesgrup/detail/data/{id}', 'aksesgrupController@data_detail')->name('aksesgrup.data_detail');
		Route::get('frm-eoffice/detail/data/{id}', 'forumEofficeController@data_detail')->name('frm-eoffice.data_detail');
		 Route::resource('frm-eoffice','forumEofficeController');
		
		// Route::post('/view','forumEofficeController@postkomentar');
		 Route::get('/{forumeoffice}/view','forumEofficeController@view');
		// Route::get('frm-eoffice/create/{id}', 'eofficeController@create')->name('frm-eoffice.create_id'); 
		// Route::get('frm-eoffice/hapus/{id}', 'forumEofficeController@hapus')->name('frm-eoffice.hapus');
		// Route::get('/ubah/{id}', 'forumEofficeController@hapus')->name('frm-eoffice.update');
		//  Route::get('/edit/{id}', 'forumEofficeController@edit');

		//Forum Laravel
			// Forum Eoffice 
		//Route::get('frm-eoffice/detail/data/{id}', 'forumEofficeController@data_detail')->name('forum.data_detail');
		Route::resource('frm-laravel','forumLaravelController');
	
		//Forum Teknis
			// Forum Eoffice 
		//Route::get('frm-eoffice/detail/data/{id}', 'forumEofficeController@data_detail')->name('forum.data_detail');
		Route::resource('frm-teknis','forumTeknisController');
	
		//Forum Teknis
			// Forum Eoffice 
		//Route::get('frm-eoffice/detail/data/{id}', 'forumEofficeController@data_detail')->name('forum.data_detail');
		Route::resource('frm-backend','forumBackendController');
		
		
		// Artikel Sisi Users
		
		//Forum Frontend
		//Route::get('frm-eoffice/detail/data/{id}', 'forumEofficeController@data_detail')->name('forum.data_detail');
		Route::resource('frm-frontend','forumFrontendController');
		
		// Artikel Eoffice
		Route::resource('art-eoffice', 'artikelEofficeController');
		
		// Artikel Laravel
		Route::resource('art-laravel', 'artikelLaravelController');
		
		// Artikel Frontend
		Route::resource('art-frontend', 'artikelFrontendController');
		
		// Artikel Backend
		Route::resource('art-backend', 'artikelBackendController');
		
		// Artikel CMS
		Route::resource('art-cms', 'artikelCmsController');
		
		// Artikel JS
		Route::resource('art-js', 'artikelJsController');
	
		// Artikel Framework
		Route::resource('art-fw', 'artikelFwController');
		
		// Artikel Framework
		Route::resource('art-sop', 'artikelSopController');
		
		// Artikel Framework
		Route::resource('art-os', 'artikelOsController');

		

	});
});
