<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFrontendpsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('frontendps', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->foreignId('kategori_id')->references('id')->on('katartikels');
            $table->string('judul')->nulllable();
            $table->text('konten')->nullable(); 
            $table->string('image')->nullable();
            $table->foreignId('user_id')->references('id')->on('users');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('frontendps');
    }
}
