<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateKatartikelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('katartikels', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('kode', 90)->nulllable();
            $table->string('nama')->nulllable();
            $table->text('keterangan')->nullable();
            $table->string('image')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->date('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('katartikels');
    }
}
