<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExperiencesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('experiences', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('dokumen_id')->nullable();
            $table->foreignId('kategori_id')->references('id')->on('kategoris');
            $table->string('nomor')->nullable(false);
            $table->string('tahun')->nullable(false);
            $table->string('nama')->nullable(false);
            $table->string('keterangan')->nullable();
            $table->date('tanggal_sk')->nullable();
            $table->timestamp('created_at');
            $table->timestamp('updated_at');
            $table->timestamp('deleted_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('experiences');
    }
}
