<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use App\Unor;
use Yajra\DataTables\Facades\DataTables;

class unorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('backend.unor.index');
    }
    public function data(Request $request)
    {
        if ($request->ajax()) {
            $menu = Unor::latest();
            return Datatables::of($menu)
            ->addIndexColumn()
            ->editColumn('nama', function($menu){
                return '<a href="'.url('unor/'.$menu->id).'" class="text-info">'.$menu->nama.'</a>';
            })
             ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" unor-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" unor-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
              ->addColumn('aksesmenu', '<center><a href="{{ url(config("master.url.admin")."/aksesmenu/".$id)  }}" class="ubah" data-toggle="tooltip" data-placement="top" title="Akses Menu"><i class="fa fa-external-link text-info"></i></a>')
              ->rawColumns(['action', 'aksesmenu', 'nama'])->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $users = Unor::find($id)->user;
            return Datatables::of($users)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.unor.tambah');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'perda_id'  => 'required',
            'nama'		=> 'required',
            'parent_id' => 'required',
            'skpd_id'   => 'required',
            'kode_unit' => 'required',
            'singkatan' => 'required',
            'detail'    => 'required',
            'unor_lama' => 'required',
            
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Unor::create($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
            }
        }
        return response()->json($respon);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $unor = Unor::find($id);
        return view('backend.unor.detail', compact('unor'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $menu = Unor::find($id);
        return view('backend.unor.ubah', ['menu' => $menu]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'perda_id'  => 'required',
            'nama'		=> 'required',
            'parent_id' => 'required',
            'skpd_id'   => 'required',
            'kode_unit' => 'required',
            'singkatan' => 'required',
            'detail'    => 'required',
            'unor_lama' => 'required',

          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Unor::find($id)->update($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil diubah']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal diubah']);
            }
        }
        return response()->json($respon);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function hapus($id)
    {
        $menu = Unor::find($id);
        return view('backend.unor.hapus', ['menu' => $menu]);
    }

    public function destroy($id)
    {
        $menu = Unor::find($id);
        if ($menu->delete()) {
            $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil dihapus']);
        } else {
            $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal dihapus']);
        }
        return response()->json($respon);
    }
}
