<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use App\Reguler;
use App\Kategori;
use App\User;
use Carbon\Carbon;
use OjiSatriani\Fungsi;
use Illuminate\Support\Str;
use Validator;

class regulerController extends Controller
{
    public function index()
    {
        return view('backend.rci.index');
    }
    public function data(Request $request)
    {
        // if ($request->ajax()) {
            $reguler = Reguler::orderBy('id','desc');
            return Datatables::of($reguler)
            ->addIndexColumn()
            ->addColumn('lampiran', function($reguler){
                return '<a href="'. $reguler->url_berkas .'">Download</a>';
            })
            ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" reguler-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" reguler-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
              ->rawColumns(['action', 'lampiran'])->make(true);
    //     } else {
    //         exit("Not an AJAX request -_-");
    //     }
     }

    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $users = Reguler::find($id)->user;
            return Datatables::of($users)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    // Tambah 
      /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        return view('backend.rci.tambah');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'dokumen_id'    => 'required',
            'kategori_id'   => 'required',
            'user_id'		=> 'required',
            'nomor'         => 'required',
            'tahun'         => 'required',
            'nama'          => 'required',
            'lampiran'      => 'required',
        //  'keterangan'    => 'required',
           // 'tanggal_sk' ,      
                      
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
              //check berkas
              $path       = NULL;
              $namafile   = NULL;
              if($request->hasFile('lampiran')){
                  $path				= 'app/reguler/'.date('Y').'/'.date('m').'/'.date('d').'/';
                  $destinationPath	= storage_path($path);
                  $namafile	        = with(new Fungsi)->namaBaru($request->file('lampiran')->getClientOriginalName(), Str::slug($request->nama.'-'.Carbon::now()));
                  $request->file('lampiran')->move($destinationPath, $namafile);
              }
              $request->request->add([
                  'file'  =>  [    
                                  'path'      => $path,
                                  'nama'      => $namafile,
                              ],           
              ]);
              // akhir check berkas
            if (Reguler::create($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
            }
        }
        return response()->json($respon);
    }


      /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $reguler = Reguler::find($id);
        return view('backend.rci.ubah', ['reguler' => $reguler]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'dokumen_id'		=> 'required',
            'kategori_id'		=> 'required',
            'nomor'	        	=> 'required',
            'tahun'	        	=> 'required',
            'nama'	            => 'required',
           // 'file' => 'required', 
        ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
              // start check value path of document
              $reguler    = Reguler::find($id);
              $path       = $reguler->file_path;
              $namafile   = $reguler->file_nama;
              if($request->hasFile('lampiran')){
                  $reguler->hapus_lampiran();
                  $path				= 'app/reguler/'.date('Y').'/'.date('m').'/'.date('d').'/';
                  $destinationPath	= storage_path($path);
                  $namafile	        = with(new Fungsi)->namaBaru($request->file('lampiran')->getClientOriginalName(), Str::slug($request->nama.'-'.Carbon::now()));
                  $request->file('lampiran')->move($destinationPath, $namafile);
              }
              $request->request->add([
                  'file'  =>  [    
                                  'path'      => $path,
                                  'nama'      => $namafile,
                              ],           
              ]);
              //akhir upadate input file
            if (Reguler::find($id)->update($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil diubah']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal diubah']);
            }
        }
        return response()->json($respon);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function hapus($id)
    {
        $reguler = Reguler::find($id);
        return view('backend.rci.hapus', ['reguler' => $reguler]);
    }
    public function destroy($id)
    {
        $reguler = Reguler::find($id);
        if ($reguler->delete()) {
            $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil dihapus']);
        } else {
            $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal dihapus']);
        }
        return response()->json($respon);
    }

    public function download($id,$gbr)
    {
        $reguler = Reguler::find($id);
        return response()->download($reguler->file_berkas);
    }

}
