<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use App\Output;
use App\Kategori;
use App\User;
use Carbon\Carbon;
use OjiSatriani\Fungsi;
use Illuminate\Support\Str;
use Validator;

class outputController extends Controller
{
    public function index()
    {
        return view('backend.output.index');
    }
    public function data(Request $request)
    {
        if ($request->ajax()) {
            $output = Output::orderBy('id', 'desc');
            return Datatables::of($output)
            ->addIndexColumn()
            ->addColumn('lampiran', function($output){
                return '<a href="'. $output->url_berkas .'">Download</a>';
            })
            ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" output-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" output-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
              ->rawColumns(['action', 'lampiran'])->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $users = Output::find($id)->user;
            return Datatables::of($users)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    // Tambah 
      /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        return view('backend.output.tambah');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'dokumen_id'    => 'required',
            'kategori_id'   => 'required',
            'user_id'		=> 'required',
            'nomor'         => 'required',
            'tahun'         => 'required',
            'nama'          => 'required',
            'lampiran'      => 'required',
        // 'keterangan' => 'required',
           // 'tanggal_sk' ,
                   
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
              //check berkas
              $path       = NULL;
              $namafile   = NULL;
              if($request->hasFile('lampiran')){
                  $path				= 'app/output/'.date('Y').'/'.date('m').'/'.date('d').'/';
                  $destinationPath	= storage_path($path);
                  $namafile	        = with(new Fungsi)->namaBaru($request->file('lampiran')->getClientOriginalName(), Str::slug($request->nama.'-'.Carbon::now()));
                  $request->file('lampiran')->move($destinationPath, $namafile);
              }
              $request->request->add([
                  'file'  =>  [    
                                  'path'      => $path,
                                  'nama'      => $namafile,
                              ],           
              ]);
              // akhir check berkas
            if (Output::create($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
            }
        }
        return response()->json($respon);
    }

      /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $output = Output::find($id);
        return view('backend.output.ubah', ['output' => $output]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'dokumen_id'	=> 'required',
            'kategori_id'	=> 'required',
            'nomor' 		=> 'required',
            'tahun'		    => 'required',
            'nama'      	=> 'required',
           // 'file' => 'required',
        ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
               // start check value path of document
               $output     = Output::find($id);
               $path       = $output->file_path;
               $namafile   = $output->file_nama;
               if($request->hasFile('lampiran')){
                   $output->hapus_lampiran();
                   $path				= 'app/output/'.date('Y').'/'.date('m').'/'.date('d').'/';
                   $destinationPath	= storage_path($path);
                   $namafile	        = with(new Fungsi)->namaBaru($request->file('lampiran')->getClientOriginalName(), Str::slug($request->nama.'-'.Carbon::now()));
                   $request->file('lampiran')->move($destinationPath, $namafile);
               }
               $request->request->add([
                   'file'  =>  [    
                                   'path'      => $path,
                                   'nama'      => $namafile,
                               ],           
               ]);
               //akhir upadate input file

            if (Output::find($id)->update($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil diubah']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal diubah']);
            }
        }
        return response()->json($respon);
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function hapus($id)
    {
        $output = Output::find($id);
        return view('backend.output.hapus', ['output' => $output]);
    }
    public function destroy($id)
    {
        $output = Output::find($id);
        if ($output->delete()) {
            $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil dihapus']);
        } else {
            $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal dihapus']);
        }
        return response()->json($respon);
    }

    public function download($id,$gbr)
    {
        //dd($id);
        $output = Output::find($id);
        return response()->download($output->file_nama);
    }

}
