<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Os;
use App\User;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Validator;

class osController extends Controller
{
    public function index()
    {
        $os = Os::all();
        return view('backend.os.index', compact('os'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            $os = Os::orderBy('id', 'desc');
            return Datatables::of($os)
            ->addIndexColumn()
            // ->addColumn('lampiran', function($os){
            //     return '<a href="'. $os->url_berkas .'">Download</a>';
            // })
            ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" os-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" os-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
              ->rawColumns(['action', 'lampiran'])->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $users = Os::find($id)->user;
            return Datatables::of($users)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function create(Request $request)
    {
        $request->request->add(['user_id' => auth()->user()->id]);
    
        return view('backend.os.tambah');
    }
    
      /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
         */
    
        public function store(Request $request)
        {
            $validator = Validator::make($request->all(), [
                
               // 'katartikel_id'		=> 'required',
                'judul'             => 'required',
                'konten'            => 'required',
                
                
                
              ]);
            if ($validator->fails()) {
                $respon = array('status'=>false, 'pesan' => $validator->messages());
            } else {
                if (Os::create($request->all())) {
                    $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
                } else {
                    $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
                }
            }
            return response()->json($respon);
        }
    
        
        public function edit($id)
        {
            $os = Os::find($id);
            return view('backend.os.ubah', ['os' => $os]);
        }
    
        /**
         * Update the specified resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function update(Request $request, $id)
        {
            $validator = Validator::make($request->all(), [
       
                'judul'		=> 'required',
                'konten' => 'required',
                
    
              ]);
            if ($validator->fails()) {
                $respon = array('status'=>false, 'pesan' => $validator->messages());
            } else {
                if (Os::find($id)->update($request->all())) {
                    $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil diubah']);
                } else {
                    $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal diubah']);
                }
            }
            return response()->json($respon);
        }
    
          /**
         * Remove the specified resource from storage.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
    
        public function hapus($id)
        {
            $os = Os::find($id);
            return view('backend.os.hapus', ['os' => $os]);
        }
    
        public function destroy($id)
        {
            $os = Os::find($id);
            if ($os->delete()) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil dihapus']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal dihapus']);
            }
            return response()->json($respon);
        }
}
