<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Session;
use Illuminate\Database\Eloquent\Model;
use Validator;
use App\Laravel;
use App\User;
use App\Katartikel;

class laravelController extends Controller
{
    public function index()
    {
        return view('backend.laravel.index');
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            $laravel = Laravel::orderBy('id', 'desc');
            return Datatables::of($laravel)
            ->addIndexColumn()
            ->addColumn('lampiran', function($laravel){
                return '<a href="'. $laravel->url_berkas .'">Download</a>';
            })
            ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" laravel-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" laravel-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
              ->rawColumns(['action', 'lampiran'])->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $users = Laravel::find($id)->user;
            return Datatables::of($users)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function create(Request $request)
    {
        // $laravel = Laravel::create();
     //$katartikel_id = Katartikel::pluck('katartikel_id');
    // $katartikel_id = array('katartikel_id' => 333);
   //  dd($katartikel_id);
    // $laravel = Laravel::whith('katartikel')->where   
   // dd($laravel);
 
   $request->request->add(['user_id' => auth()->user()->id]);
 //  dd($request->all());
   //$laravel = Laravel::create($request->all());
  
     return view('backend.laravel.tambah')->with($katartikel_id);
    //    [ 'laravels' => Laravel::with('katartikel')]

    }

      /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            
           // 'katartikel_id'		=> 'required',
            'judul'             => 'required',
            'konten'            => 'required',
            
            
            
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Laravel::create($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
            }
        }
        return response()->json($respon);
    }

    public function edit($id)
    {
        $laravel = Laravel::find($id);
        $katartikel_id = Laravel::pluck('id','katartikel_id');
        return view('backend.laravel.ubah', compact('laravel','katartikel_id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
       //     'katartikel_id'  => 'required',
            'judul'		=> 'required',
            'konten' => 'required',
            

          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Laravel::find($id)->update($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil diubah']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal diubah']);
            }
        }
        return response()->json($respon);
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function hapus($id)
    {
        $laravel = Laravel::find($id);
        return view('backend.laravel.hapus', ['laravel' => $laravel]);
    }

    public function destroy($id)
    {
        $laravel = Laravel::find($id);
        if ($laravel->delete()) {
            $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil dihapus']);
        } else {
            $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal dihapus']);
        }
        return response()->json($respon);
    }

}
