<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use App\Katartikel;
use Validator;

class katartikelController extends Controller
{
    public function index()
    {
        return view('backend.katartikel.index');
    }

    public function data(Request $request)
    {
        //$katartikel = Katartikel::all();
              $katartikel = Katartikel::orderBy('id','desc');
              return Datatables::of($katartikel)
            // ->addIndexColumn()
            // ->addColumn('lampiran', function($katartikel){
            //     return '<a href="'. $katartikel->file_url .'">Download</a>';
            // })
             ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" katartikel-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" katartikel-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
               ->rawColumns(['action', 'lampiran'])->make(true);
        // } else {
        //      exit("Not an AJAX request -_-");
        //  }
    }
    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $katartikel = Katartikel::find($id)->katartikel;
            return Datatables::of($katartikel)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        return view('backend.katartikel.tambah');
    }

     /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

     /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
         
            'katartikel_id'		=> 'required',
            'nama'      => 'required',
            'keterangan'=> 'required',
            
            
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Katartikel::create($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
            }
        }
        return response()->json($respon);
    }

     /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $katartikel = Katartikel::find($id);
        return view('backend.katartikel.ubah', ['katartikel' => $katartikel]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'id'  => 'required',
            'katartikel_id'		=> 'required',
            'nama' => 'required',
            'keterangan'   => 'required',
    //        'image' => 'required',
            
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Katartikel::find($id)->update($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil diubah']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal diubah']);
            }
        }
        return response()->json($respon);
    }


    

}
