<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use App\Formal;
use App\Kategori;
use App\User;
use Carbon\Carbon;
use OjiSatriani\Fungsi;
use Illuminate\Support\Str;
use Validator;

class formalController extends Controller
{
    public function index(Request $request)
    {
        if($request->has('cari')){
            $data_formal = \App\Formal::where('nama','LIKE','%'.$request->cari.'%')->get();
        }else{
            $data_formal = \App\Formal::all();
        }
        return view('backend.formal.index');
    }
    public function data(Request $request)
    {
       // if ($request->ajax()) {
            $formal = Formal::orderBy('id','desc');
            return Datatables::of($formal)
            ->addIndexColumn()
            ->addColumn('lampiran', function($formal){
                return '<a href="'. $formal->url_berkas .'">Download</a>';
            })
            ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" formal-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" formal-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
              ->rawColumns(['action', 'lampiran'])->make(true);
        // } else {
        //     exit("Not an AJAX request -_-");
        // }
    }

    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $users = Formal::find($id)->user;
            return Datatables::of($users)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        return view('backend.formal.tambah');
    }

    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'dokumen_id'    => 'required',
            'kategori_id'   => 'required',
            'user_id'		=> 'required',
            'nomor'         => 'required',
            'tahun'         => 'required',
            'nama'          => 'required',
            'lampiran'      => 'required',
        //  'keterangan'    => 'required',
           // 'tanggal_sk' ,
             
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
                //check berkas
                $path       = NULL;
                $namafile   = NULL;
                if($request->hasFile('lampiran')){
                    $path				= 'app/formal/'.date('Y').'/'.date('m').'/'.date('d').'/';
                    $destinationPath	= storage_path($path);
                    $namafile	        = with(new Fungsi)->namaBaru($request->file('lampiran')->getClientOriginalName(), Str::slug($request->nama.'-'.Carbon::now()));
                    $request->file('lampiran')->move($destinationPath, $namafile);
                }
                $request->request->add([
                    'file'  =>  [    
                                    'path'      => $path,
                                    'nama'      => $namafile,
                                ],           
                ]);
                // akhir check berkas

            if (Formal::create($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
            }
        }
        return response()->json($respon);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $formal = Formal::find($id);
        return view('backend.formal.ubah', compact('formal'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'dokumen_id'		=> 'required',
            'kategori_id'		=> 'required',
            'nomor'		=> 'required',
            'tahun'		=> 'required',
            'nama'	=> 'required',
           // 'file' => 'required',
            
        ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            // start check value path of document
            $formal     = Formal::find($id);
            $path       = $formal->file_path;
            $namafile   = $formal->file_nama;
            if($request->hasFile('lampiran')){
                $formal->hapus_lampiran();
                $path				= 'app/formal/'.date('Y').'/'.date('m').'/'.date('d').'/';
                $destinationPath	= storage_path($path);
                $namafile	        = with(new Fungsi)->namaBaru($request->file('lampiran')->getClientOriginalName(), Str::slug($request->nama.'-'.Carbon::now()));
                $request->file('lampiran')->move($destinationPath, $namafile);
            }
            $request->request->add([
                'file'  =>  [    
                                'path'      => $path,
                                'nama'      => $namafile,
                            ],           
            ]);
            //akhir upadate input file
            if (Formal::find($id)->update($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil diubah']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal diubah']);
            }
        }
        return response()->json($respon);
    }
     /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function hapus($id)
    {
        $formal = Formal::find($id);
        return view('backend.formal.hapus', ['formal' => $formal]);
    }
    public function destroy($id)
    {
        $formal = Formal::find($id);
        if ($formal->delete()) {
            $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil dihapus']);
        } else {
            $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal dihapus']);
        }
        return response()->json($respon);
    }

    public function download($id,$gbr)
    {
      //  dd($id);
  // $formaldownload = link_to_asset('')
        $formal = Formal::find($id);
        return response()->download($formal->file_berkas);
    }

    public function downloadFormal($id, $gbr)
    {
        $formal = Formal::find($id);
        return response()->download($formal->file_berkas);
    }
    
    // public function download($id,$gbr)
    // {
    //     $berkas = Berkas::find($id);
    //     return response()->download($berkas->file_berkas);
    // }

}


// INSERT INTO `formals` (`id`, `dokumen_id`, `kategori_id`, `nomor`, `tahun`, `nama`, `keterangan`, `tanggal_sk`, `created_at`, `updated_at`, `deleted_at`) VALUES ('1', '5822', '1', '345', '2021', 'Pergub 58 2021', 'fdhskjfdk skfksd ', NULL, NULL, NULL, NULL), ('2', '2553', '2', '43', '2020', 'Keputusan Gubernur Riau', 'hdahaksh ahkddsfh', NULL, NULL, NULL, NULL);