<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Eoffice;
use App\Katartikel;
use App\User;

class eofficeController extends Controller
{
    public function index()
    {
        return view('backend.eoffice.index');
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            $eoffice = Eoffice::orderBy('id', 'desc');
            return Datatables::of($eoffice)
            ->addIndexColumn()
            // ->addColumn('lampiran', function($eoffice){
            //     return '<a href="'. $eoffice->url_berkas .'">Download</a>';
            // })
            ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" eoffice-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" eoffice-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
              ->rawColumns(['action', 'lampiran'])->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $users = Eoffice::find($id)->user;
            return Datatables::of($users)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function create(Request $request)
    {
      
     return view('backend.eoffice.tambah');
  

    }

      /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            
            
            'judul'             => 'required',
            'konten'            => 'required',
            
            
            
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Eoffice::create($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
            }
        }
        return response()->json($respon);
    }

    public function edit($id)
    {
        $eoffice = Eoffice::find($id);
      
        return view('backend.eoffice.ubah', compact('eoffice'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
       
            'judul'		=> 'required',
            'konten' => 'required',
            

          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Eoffice::find($id)->update($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil diubah']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal diubah']);
            }
        }
        return response()->json($respon);
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function hapus($id)
    {
        $eoffice = Eoffice::find($id);
        return view('backend.eoffice.hapus', ['eoffice' => $eoffice]);
    }

    public function destroy($id)
    {
        $eoffice = Eoffice::find($id);
        if ($eoffice->delete()) {
            $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil dihapus']);
        } else {
            $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal dihapus']);
        }
        return response()->json($respon);
    }







}
