<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Cms;
use App\User;
use Yajra\DataTables\Facades\DataTables;

class cmsController extends Controller
{
    public function index()
    {
        $cms = Cms::all();
        return view('backend.cms.index', compact('cms'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            $cms = Cms::orderBy('id', 'desc');
            return Datatables::of($cms)
            ->addIndexColumn()
            // ->addColumn('lampiran', function($cms){
            //     return '<a href="'. $cms->url_berkas .'">Download</a>';
            // })
            ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" cms-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" cms-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
              ->rawColumns(['action', 'lampiran'])->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $users = Cms::find($id)->user;
            return Datatables::of($users)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function create(Request $request)
    {
        $request->request->add(['user_id' => auth()->user()->id]);
    
        return view('backend.cms.tambah');
    }
    
      /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
         */
    
        public function store(Request $request)
        {
            $validator = Validator::make($request->all(), [
                
               // 'katartikel_id'		=> 'required',
                'judul'             => 'required',
                'konten'            => 'required',
                
                
                
              ]);
            if ($validator->fails()) {
                $respon = array('status'=>false, 'pesan' => $validator->messages());
            } else {
                if (Cms::create($request->all())) {
                    $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
                } else {
                    $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
                }
            }
            return response()->json($respon);
        }

            
        public function edit($id)
        {
            $cms = Cms::find($id);
            return view('backend.cms.ubah', ['cms' => $cms]);
        }
    
        /**
         * Update the specified resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
        public function update(Request $request, $id)
        {
            $validator = Validator::make($request->all(), [
       
                'judul'		=> 'required',
                'konten' => 'required',
                
    
              ]);
            if ($validator->fails()) {
                $respon = array('status'=>false, 'pesan' => $validator->messages());
            } else {
                if (cms::find($id)->update($request->all())) {
                    $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil diubah']);
                } else {
                    $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal diubah']);
                }
            }
            return response()->json($respon);
        }
    
          /**
         * Remove the specified resource from storage.
         *
         * @param  int  $id
         * @return \Illuminate\Http\Response
         */
    
        public function hapus($id)
        {
            $cms = Cms::find($id);
            return view('backend.cms.hapus', ['cms' => $cms]);
        }
    
        public function destroy($id)
        {
            $cms = Cms::find($id);
            if ($cms->delete()) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil dihapus']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal dihapus']);
            }
            return response()->json($respon);
        }
    

}
