<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Validator;
use App\Backendp;
use App\Katartikel;
use App\User;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class backendpController extends Controller
{
    public function index()
    {
       $backendp = Backendp::all();
        return view('backend.backendp.index', compact('backendp'));
    }

    public function data(Request $request)
    {
        if ($request->ajax()) {
            $backendp = Backendp::orderBy('id','desc');
            return Datatables::of($backendp)
            ->addIndexColumn()
            // ->addColumn('lampiran', function($backendp){
            //     return '<a href="'. $backendp->url_berkas .'">Download</a>';
            // })
            ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" backendp-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" backendp-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
              ->rawColumns(['action', 'lampiran'])->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $users = Backendp::find($id)->user;
            return Datatables::of($users)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }


      /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create()
    {
        
        return view('backend.backendp.tambah');
    }

     /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

     /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
          
           
            'judul'              => 'required',
            'konten'            => 'required',
            
            
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Backendp::create($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
            }
        }
        return response()->json($respon);
    }

    public function edit($id)
    {
        $backendp = Backendp::find($id);
      
        return view('backend.backendp.ubah', compact('backendp'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
       
            'judul'		=> 'required',
            'konten' => 'required',
            

          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (backendp::find($id)->update($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil diubah']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal diubah']);
            }
        }
        return response()->json($respon);
    }

      /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function hapus($id)
    {
        $backendp = backendp::find($id);
        return view('backend.backendp.hapus', ['backendp' => $backendp]);
    }

    public function destroy($id)
    {
        $backendp = backendp::find($id);
        if ($backendp->delete()) {
            $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil dihapus']);
        } else {
            $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal dihapus']);
        }
        return response()->json($respon);
    }

}
