<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Collection;
use App\Eoffice;
use App\User;
use Illuminate\Support\Facades\Validator;


class artikelEofficeController extends Controller
{
    public function index()
    {
        $eoffice = Eoffice::all();
        return view('backend.art-eoffice.index', compact('eoffice'));
    }

    public function create(Request $request)
    {
        $request->request->add(['user_id' => auth()->user()->id]);
        return view('backend.art-eoffice.tambah');
    }

      /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            
            
            'judul'             => 'required',
            'konten'            => 'required',
            
            
            
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Eoffice::create($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
            }
        }
        return response()->json($respon);
    }
}
