<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Builder;
use Validator;
use App\Artikel;
use App\Katartikel;
use App\Eoffice;
use App\Laravel;
use App\Frontendp;
use App\Backendp;


class artikelController extends Controller
{
    public function index()
    {
        $eoffice = DB::table('eoffices')->latest('created_at')->get();
        // $laravel =DB::table('laravels')->latest('created_at')->first();
        // $frontend =DB::table('frontendps')->latest('created_at')->first();
        // $backend = DB::table('backendps')->latest('created_at')->first();

        return view('backend.artikel.index', compact('eoffice'));
    }

    public function latest($column = 'created_at')
    {

    }

    public function data(Request $request)
    {
        //$artikel = Artikel::all();
              $artikel = Artikel::orderBy('id','desc');
              return Datatables::of($artikel)
            // ->addIndexColumn()
            // ->addColumn('lampiran', function($artikel){
            //     return '<a href="'. $artikel->file_url .'">Download</a>';
            // })
             ->addColumn(
                 'action',
                           '<center>
                               <a class="edit ubah" data-toggle="tooltip" data-placement="top" title="Edit" artikel-id="{{ $id }}" href="#edit-{{ $id }}">
                                   <i class="fa fa-pencil text-warning"></i>
                               </a>&nbsp; &nbsp;
                               <a class="delete hidden-xs hidden-sm hapus" data-toggle="tooltip" data-placement="top" title="Delete" artikel-id="{{ $id }}" href="#hapus-{{ $id }}" >
                                   <i class="fa fa-trash text-danger"></i>
                               </a>
                           </center>'
                        )
               ->rawColumns(['action', 'lampiran'])->make(true);
        // } else {
        //      exit("Not an AJAX request -_-");
        //  }
    }
    public function data_detail(Request $request, $id)
    {
        if ($request->ajax()) {
            $artikel = Artikel::find($id)->artikel;
            return Datatables::of($artikel)
            ->addIndexColumn()->make(true);
        } else {
            exit("Not an AJAX request -_-");
        }
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function create(Request $request)
    {
        $artikel = Artikel::create();
        $kategori_artikel = Katartikel::pluck('katartikel_id', 'id');
       // dd($kategori_artikel);
        // $laravel = Laravel::whith('katartikel')->where   
       // dd($laravel);
     
       $request->request->add(['user_id' => auth()->user()->id]);
        return view('backend.artikel.tambah', compact('artikel'))->with('kategori_artikel');
       // return view('backend.artikel.tambah');
    }

      /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            
            
            'judul'             => 'required',
            'konten'            => 'required',
            
            
            
          ]);
        if ($validator->fails()) {
            $respon = array('status'=>false, 'pesan' => $validator->messages());
        } else {
            if (Artikel::create($request->all())) {
                $respon = array('status'=>true, 'pesan' => ['msg' => 'Data berhasil disimpan']);
            } else {
                $respon = array('status'=>false, 'pesan' => ['msg' => 'Data gagal disimpan']);
            }
        }
        return response()->json($respon);
    }

    public function rmeoffice(){
        //  $request->request->add(['user_id' => auth()->user()->id]);
  
           $eoffice = Eoffice::all();
        //    $laravel = Laravel::all();
        //    $backend = Backendp::all();
        //    $frontend = Frontendp::all();
        //    $eoffice = Eoffice::all();
  
           return view('backend.artikel.vieweoffice', compact('eoffice'));
       }

    public function rmlaravel(){
        //  $request->request->add(['user_id' => auth()->user()->id]);
  
           $lihatlaravel = lihatlaravel();
        //    $laravel = Laravel::all();
        //    $backend = Backendp::all();
        //    $frontend = Frontendp::all();
        //    $eoffice = Eoffice::all();
  
           return view('backend.artikel.viewlaravel')->with($lihatlaravel);
       }

        public function tampil(Request $request, $id){
        //  $request->request->add(['user_id' => auth()->user()->id]);  
           //$laravel = Laravel::all();
          
           return view('backend.artikel.viewlaravel');
       }


       public function artikeleoffice()
       {
           $getEoffice = Eoffice::all();
           return view('backend.artikel.geteoffice', compact('getEoffice'));
       }
       
       public function artikellaravel()
       {
           $laravel = Laravel::all();

           return view('backend.artikel.getlaravel', compact('laravel', $laravel));
       }


    
    
}
