<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class Forum extends Model
{
    use HasFactory, sluggable;

    public function user(){
        return $this->belongsTo('App\User');
    }

    public function komentar(){
        return $this->hasMany('App\Komentar');
    }

    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'judul'
            ]
            ];
    }

    public function katarikel()
    {
        return $this->belongsTo('App\Katartikel');
    }

    public function laravel()
    {
        return $this->hasMany('App\Laravel');
    }
}
